#include <windows.h>
#include <stdio.h>


FILE *fp;


UINT8 buf[0x800000];
INT32 bufSize;



// Rise of the Triad -> Shadow Warrior
UINT8 patch1Scan[] =
{
	0xBA, 0x40, 0x00, 0x00, 0x00,
	0x89, 0xF3,
	0x89, 0xC8,
	0xE8, -1, -1, -1, -1,
	
	0xBA, 0x7B, 0x00, 0x00, 0x00,
	0x89, 0xF3,
	0x89, 0xC8,
	0xE8, -1, -1, -1, -1,
	
	0xBA, 0x78, 0x00, 0x00, 0x00,
	0x89, 0xF3,
	0x89, 0xC8,
	0x41,
	0xE8, -1, -1, -1, -1,
};


INT16 patch1Raw[] =
{
	0xEB, 0x05, 0x40, 0x7B, 0x78, 0x20, 0x00, 0x57,
	0xE8, 0x00, 0x00, 0x00, 0x00, 0x5F, 0x83, 0xEF,
	0x0B, 0x31, 0xDB, 0x31, 0xD2, 0x8A, 0x17, 0x84,
	0xD2, 0x9C, 0x89, 0xC8,
	0xE8FF, 0x57, 0xFF, 0xFF, 0xFF,
	0x47, 0x9D, 0x75, 0xEC, 0x5F, 0x41, 0xEB, 0x02
};




UINT8 patch2Scan[] =
{
	//0x8A, 0x04, 0x24, 0x8D, 0x51, 0xFF, 0xEE, 0x83, 0xC4, 0x04, 0x5A, 0x59, 0x5B, 0xC3

	0x8B, 0xC0,
	0x0C, 0x80,
	0xE8, -1, -1, -1, -1,
	0x89, 0xD0,
	0xE8, -1, -1, -1, -1,
	0x89, 0xD8,
	0xEB, 0xB6,


	0x8B, 0xC0,
	0x0C, 0x90,
	0xE8, -1, -1, -1, -1,
	0x89, 0xD0,
	0xE8, -1, -1, -1, -1,
	0x89, 0xD8,
	0xEB, 0xA2,
};


INT16 patch2Raw[] =
{
	// 80
	0x8B, 0xC0,
	0x0C, 0x80,
	0xE8, -1, -1, -1, -1,
	0x89, 0xD0,
	0xE8, -1, -1, -1, -1,
	0x89, 0xD8,
	0xEB, 0xB6,


	// 90, A0, B0
	0x8B, 0xC0, 0x0C, 0x90, 0xEB, 0xEA, 0x0C, 0xB0, 0xEB, 0xE6, 0x50, 0x8A, 0x06, 0x3C, 0xF7, 0x9C, 0xEB, 0x08, 0x90, 0x90,
	0x8B, 0xC0, 0x0C, 0xA0, 0xEB, 0xD6, 0xE8, 0x97, 0xFF, 0xFF, 0xFF, 0x46, 0x9D, 0x75, 0xE8, 0x5E, 0x58, 0xEB, 0x2F, 0x90,
	0x8B, 0xC0, 0x84, 0xC0, 0x75, 0xD8, 0x80, 0xFA, 0x79, 0x75, 0xD3, 0x56, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x5E, 0x83, 0xC6, 0x2D, 0xEB, 0xCB,


	// C0
	0x8D, 0x40, 0x00,
	0x0C, 0xC0, 0xE8, -1, -1, -1, -1,
	0x89, 0xD0,
	0xE9, 0x66, 0xFF, 0xFF, 0xFF,
	

	// D0
	0x8B, 0xC0, 0x0C, 0xD0, 0xEB, 0xEE, 0xB2, 0x79, 0xEB, 0xAC, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
	

	// E0
	0x8B, 0xC0, 0x0C, 0xE0, 0xEB, 0x8A, 0xF0, 0x41, 0x10, 0x42, 0x12, 0x40, 0x00, 0x7F, 0x00, 0x41, 0xF7, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90
};



INT Patch( INT type, INT addr, INT scanSize, INT patchSize, BYTE patchScan[], INT16 patchRaw[] )
{
	for( INT lcv = 0; lcv < scanSize; lcv++ )
	{
		// wildcard
		if( patchScan[ lcv ] == (UINT8) -1 )
			continue;


		if( patchScan[ lcv ] != buf[ addr + lcv ] )
			break;
	}


	// not found
	if( lcv != scanSize )
		return 0;


	// #################################################
	// #################################################
	// #################################################

	INT diff;


	if( type == 1 )
	{
		// Apogee special call
		diff = *( (INT32 *) (buf + addr + 10) ) - (INT32) 0xFFFFFF6A;
	}



	for( lcv = 0; lcv < patchSize; lcv++ )
	{
		// wildcard
		if( patchRaw[ lcv ] == (INT16) -1 )
			continue;


		// ptr diff
		if( patchRaw[ lcv ] == (INT16) 0xE8FF )
		{
			buf[ addr + lcv ] = 0xE8;

			buf[ addr + lcv + 1 ] = (UINT8) patchRaw[ lcv + 1 ];
			buf[ addr + lcv + 2 ] = (UINT8) patchRaw[ lcv + 2 ];
			buf[ addr + lcv + 3 ] = (UINT8) patchRaw[ lcv + 3 ];
			buf[ addr + lcv + 4 ] = (UINT8) patchRaw[ lcv + 4 ];


			*( (INT32 *)( buf + addr + lcv + 1 ) ) += diff;


			lcv += 4;
			continue;
		}


		buf[ addr + lcv ] = (UINT8) patchRaw[ lcv ];
	}


	return 1;
}



INT CALLBACK WinMain( HINSTANCE, HINSTANCE, LPSTR, INT )
{
	BOOL found;


	found = FALSE;


	fp = fopen( "ROTT.EXE", "rb+" );
	if( fp ) found = TRUE;


	if( !fp )
	{
		fp = fopen( "DUKE3D.EXE", "rb+" );
		if( fp ) found = TRUE;
	}


	if( !fp )
	{
		fp = fopen( "BLOOD.EXE", "rb+" );
		if( fp ) found = TRUE;
	}


	if( !fp )
	{
		fp = fopen( "SW.EXE", "rb+" );
		if( fp ) found = TRUE;
	}



	if( !fp )
	{
		MessageBox( NULL, "No game found", "Apogee / 3D Realms", MB_OK );
		return 0;
	}


	// ##################################################
	// ##################################################
	// ##################################################

	// file size
	fseek( fp, 0, SEEK_END );
	bufSize = ftell(fp);


	fseek( fp, 0, SEEK_SET );
	fread( buf, 1, bufSize, fp );



	// scan for pattern
	for( INT lcv = 0; lcv < bufSize; lcv++ )
	{
		if( Patch( 1, lcv, sizeof(patch1Scan), sizeof(patch1Raw) / sizeof(INT16), patch1Scan, patch1Raw ) )
			MessageBox( 0, "Patch - Bank reset", "Game patch", MB_OK );


		if( Patch( 2, lcv, sizeof(patch2Scan), sizeof(patch2Raw) / sizeof(INT16), patch2Scan, patch2Raw ) )
			MessageBox( 0, "Patch - GS reset", "Game patch", MB_OK );
	}


	// ##################################################
	// ##################################################
	// ##################################################

	// set to write mode
	fseek( fp, 0, SEEK_SET );


	fwrite( buf, 1, bufSize, fp );
	fclose( fp );


	return 0;
}
